﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter08.Listing08_01
{
    // Do deklarowania typów bezpośrednich stosuj słowo kluczowe struct.
    struct Angle
    {
        public Angle(int degrees, int minutes, int seconds)
        {
            Degrees = degrees;
            Minutes = minutes;
            Seconds = seconds;
        }

        // Tworzenie automatycznie implementowanych właściwości tylko do odczytu 
        // wprowadzony w wersji C# 6.0.
        public int Degrees { get; }
        public int Minutes { get; }
        public int Seconds { get; }

        public Angle Move(int degrees, int minutes, int seconds)
        {
            return new Angle(
                Degrees + degrees,
                Minutes + minutes,
                Seconds + seconds);
        }
    }

    // Deklarowanie klasy (typu referencyjnego).
    // Zadeklarowanie tego typu jako struktury spowoduje utworzenie typu
    // bezpośredniego o wielkości większej niż 16 bajtów.
    class Coordinate
    {
        public Angle Longitude { get; set; }

        public Angle Latitude { get; set; }
    }

}