﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter18.Listing18_09
{
    using System;
    using System.Diagnostics;
    using System.Threading;

    public class Program
    {
        public static Stopwatch clock = new Stopwatch();
        public static void Main()
        {
            try
            {
                clock.Start();
                // Rejestrowanie wywołania zwrotnego w celu otrzymywania powiadomień 
                // o nieobsłużonych wyjątkach.
                AppDomain.CurrentDomain.UnhandledException +=
                  (s, e) =>
                  {
                      Message("Rozpoczynanie obsługi zdarzeń");
                      Delay(4000);
                  };

                Thread thread = new Thread(() =>
                {
                    Message("Zgłaszanie wyjątku.");
                    throw new Exception();
                });
                thread.Start();

                Delay(2000);
            }
            finally
            {
                Message("Wykonywanie bloku finally.");
            }
        }

        static void Delay(int i)
        {
            Message($"Usypianie na {i} ms");
            Thread.Sleep(i);
            Message("Wzbudzono");
        }

        static void Message(string text)
        {
            Console.WriteLine("{0}:{1:0000}:{2}",
              Thread.CurrentThread.ManagedThreadId,
                    clock.ElapsedMilliseconds,
              text);
        }
    }
}
