﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter11.Listing11_44A
{
    class Food { }

    class Pizza : Food { }

    class Salad : Food { }

    class Document { }

    class ComputerProgram : Document { }

    interface ITransformer<in TSource, out TTarget>
    {
        TTarget Transform(TSource source);
    }

    // Programista to urządzenie, które przekształca
    // jedzenie na programy komputerowe:
    class Programmer : ITransformer<Food, ComputerProgram>
    {
        public ComputerProgram Transform(Food f)
        {
            // ...
            return new ComputerProgram();
        }
    }

    class Program
    {
        static void Main()
        {
            var programmer = new Programmer();
            ComputerProgram cp = programmer.Transform(new Salad());

            // Programistę można przekształcać za pomocą kowariancji i
            // kontrawariancji. Ponieważ programista potrafi zmieniać 
            // jedzenie w programy komputerowe, można go wykorzystać jako
            // urządzenie przekształcające pizzę w dokumenty.
            ITransformer<Pizza, Document> transformer = programmer;
            Document d = transformer.Transform(new Pizza());
        }
    }
}