﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter10.Listing10_01
{
    using System;

    public sealed class TextNumberParser
    {
        public static int Parse(string textDigit)
        {
            string[] digitTexts = 
                { "zero", "jeden", "dwa", "trzy", "cztery", 
                  "pięć", "sześć", "siedem", "osiem", "dziewięć" };

            int result = Array.IndexOf(
                digitTexts, textDigit.ToLower());

            if(result < 0)
            {
#if !PRECSHARP6
                throw new ArgumentException(
                    "Argument nie reprezentuje cyfry", nameof(textDigit));
#else
                throw new ArgumentException(
                    "Argument nie reprezentuje cyfry",
                    "textDigit");
#endif
            }

            return result;
        }
    }
}