﻿using System;

namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter09.Listing09_03
{
    using AddisonWesley.Michaelis.EssentialCSharp.Chapter09.Listing09_06;

    public class Program
    {
        public static void Main()
        {
            ProductSerialNumber serialNumber1 =
                new ProductSerialNumber("PV", 1000, 09187234);
            ProductSerialNumber serialNumber2 = serialNumber1;
            ProductSerialNumber serialNumber3 =
                new ProductSerialNumber("PV", 1000, 09187234);

            // Te obiekty SĄ tożsame.
            if (!ProductSerialNumber.ReferenceEquals(serialNumber1,
                serialNumber2))
            {
                throw new Exception(
                    "serialNumber1 NIE zawiera tej samej " +
                    "referencji co serialNumber2");
            }
            // Dlatego też są równe.
            else if(!serialNumber1.Equals(serialNumber2))
            {
                throw new Exception(
                    "serialNumber1 NIE ma wartości równej serialNumber2");
            }
            else
            {
                Console.WriteLine(
                    "serialNumber1 ma referencję równą z serialNumber2");
                Console.WriteLine(
                    "serialNumber1 ma wartość równą z serialNumber2");
            }


            // Te obiekty NIE są tożsame
            if(ProductSerialNumber.ReferenceEquals(serialNumber1,
                    serialNumber3))
            {
                throw new Exception(
                    "serialNumber1 MA referencję równą z " +
                    "serialNumber3");
            }
            // Mają jednak równe wartości (jeśli metoda Equals jest przeciążona).
            else if (!serialNumber1.Equals(serialNumber3) ||
                serialNumber1 != serialNumber3)
            {
                throw new Exception(
                    "serialNumber1 NIE ma wartości równej z serialNumber3");
            }

            Console.WriteLine("serialNumber1 ma wartość równą z serialNumber3");
        }
    }
}