﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Threading;

namespace AddisonWesley.Michaelis.EssentialCSharp.Shared
{
    public class Program
    {
        public static void Main(string[] args)
        {
            string listing;
            IEnumerable<string> arguments = null;
            if (args.Length == 0)
            {
                Console.Write("Wprowadź numer listingu do uruchomienia (np. dla listingu 18.1 wpisz \"18.1\"): ");
                listing = Console.ReadLine();
            }
            else
            {
                listing = args[0];
                arguments = args.Skip(1);
            }

            LaunchMain(listing, arguments);
        }

        private static void LaunchMain(string listing, IEnumerable<string> stringArguments)
        {
            Console.WriteLine();
            Console.WriteLine("____________________________");
            Console.WriteLine();
            ConsoleColor originalColor = Console.ForegroundColor;

            try
            {

                listing = ParseListingName(listing);

                Type target = Assembly.GetExecutingAssembly().GetTypes().First(
                    type => type.FullName.Contains(listing + "."));
                var method = (MethodInfo)target.GetMember("Main").First();

                object[] arguments;
                if (!method.GetParameters().Any())
                {
                    arguments = null;
                }
                else
                {
                    if (stringArguments == null)
                    {
                        arguments = new object[] { GetArguments() };
                    }
                    else
                    {
                        arguments = new object[] { stringArguments.ToArray() };
                    }
                }
                if (method.GetCustomAttributes(typeof(STAThreadAttribute), false).Any())
                {
                    Thread thread = new Thread(() => method.Invoke(null, arguments));
                    thread.SetApartmentState(ApartmentState.STA);
                    thread.Start();
                    thread.Join();
                }
                else
                {
                    method.Invoke(null, arguments);
                }
            }
            catch (TargetParameterCountException exception)
            {
                throw new InvalidOperationException(
                    string.Format("Błąd krytyczny w trakcie wykonywania listingu {0}.\n", listing),
                        exception);
            }
            catch (InvalidOperationException)
            {
                Console.ForegroundColor = ConsoleColor.Red;
                Console.WriteLine("----Wyjątek----");
                Console.WriteLine(string.Format("Błąd. Nie można uruchomić listingu '{0}'. Upewnij się, że podałeś poprawny listing w odpowiednim formacie", listing));
            }
            catch (Exception exception)
            {
                Console.ForegroundColor = ConsoleColor.Red;
                Console.WriteLine("----Wyjątek----");
                if (exception.InnerException != null)
                {                    
                    // Typ ExceptionDispatchInfo jest używany za pomocą refleksji, ponieważ
                    // nie jest dostępny w wersji .NET 4.0 i w starszych wersjach, a kod ma
                    // być zgodnymi z nimi, a jednocześnie wykorzystywać ten typ, gdy jest dostępny.
                    Type exceptionDispatchInfoType =
                            Type.GetType(
                                "System.Runtime.ExceptionServices.ExceptionDispatchInfo");
                    if (exceptionDispatchInfoType != null)
                    {
                        dynamic exceptionDispatchInfo = exceptionDispatchInfoType.GetMethod("Capture")
                            .Invoke(exceptionDispatchInfoType, new object[] { exception.InnerException });
                        exceptionDispatchInfo.Throw();
                    }
                    else
                        throw exception.InnerException;
                }
                else
                {
                    Console.ForegroundColor = ConsoleColor.Red;
                    Console.WriteLine(string.Format("Listing {0} zgłosił wyjątek {1}.", listing, exception.GetType()));
                }
            }
            finally
            {
                Console.ForegroundColor = originalColor;

                Console.WriteLine();
                Console.WriteLine("____________________________");
                Console.WriteLine("Koniec pracy kodu z listingu " + listing);
                Console.Write("Wciśnij dowolny klawisz, aby zakończyć.");
                Console.ReadKey();
            }
        }

        private static string[] GetArguments()
        {
            string[] args;

            Console.WriteLine();
            Console.WriteLine(
                "Listing wymaga podawanych przez użytkownika argumentów dla metody main. Sprawdź listing i wprowadź argumenty lub wciśnij enter, aby przekazać null: ");
            string userArguments = Console.ReadLine();
            Console.WriteLine();
            Console.WriteLine();

            if (userArguments != null)
            {
                userArguments = userArguments.Trim();
            }

            if (string.IsNullOrWhiteSpace(userArguments))
            {
                args = new string[0];
            }
            else
            {
                args = userArguments.Split(new[] { ' ' });
            }
            return args;
        }

        private static string ParseListingName(string listing)
        {
            string[] chapterListing = listing.Split('.');
            listing = string.Empty;

            int startPosition;

            if (!int.TryParse(chapterListing[0], out startPosition))
            {
                startPosition = 1;
                listing += chapterListing[0].ToUpper() + ".";
            }
            else
            {
                startPosition = 0;
            }

            for (int index = startPosition; index < chapterListing.Length; index++)
            {
                listing += chapterListing[index].PadLeft(2, '0') + ".";
            }

            listing = listing.Substring(0, listing.Length - 1);
            return listing.Replace('.', '_');
        }
    }
}