namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter16.Listing16_10
{
    using System;

    // ----

    interface IPair<T>
    {
        T First { get; }

        T Second { get; }

        T this[PairItem index] { get; }
    }

    // ----

    public enum PairItem
    {
        First,
        Second
    }

    // ----

    public struct Pair<T> : IPair<T>
    {
        public Pair(T first, T second)
        {
            First = first;
            Second = second;
        }

        public T First { get; } // Automatycznie generowana waciwo z samym getterem (z wersji C# 6.0). 

        public T Second { get; } // Automatycznie generowana waciwo z samym getterem (z wersji C# 6.0). 

        [System.Runtime.CompilerServices.IndexerName("Entry")]
        public T this[PairItem index]
        {
            get
            {
                switch(index) 
                {
                    case PairItem.First:
                        return First;
                    case PairItem.Second:
                        return Second;
                    default:
                        throw new NotImplementedException(
                            string.Format(
                            "Wyliczenie nie zawiera wartoci {0}",
                            index.ToString()));
                }
            }
        }
    }
}
