﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter13.Listing13_09
{
    using System;
    using Listing13_01;
    using Listing13_05;

    public class Program
    {
        public static void Main()
        {
            Thermostat thermostat = new Thermostat();
            Heater heater = new Heater(60);
            Cooler cooler = new Cooler(80);
            string temperature;

            // Składnia dostępna od wersji C# 2.0.
            thermostat.OnTemperatureChange +=
                heater.OnTemperatureChanged;
            // Składnia z wersji C# 3.0. W wersji
            // C# 2.0 zastosuj metodę anonimową.
            thermostat.OnTemperatureChange +=
                (newTemperature) =>
                    {
                        throw new InvalidOperationException();
                    };
            thermostat.OnTemperatureChange +=
                cooler.OnTemperatureChanged;

            Console.Write("Wprowadź temperaturę: ");
            temperature = Console.ReadLine();
            thermostat.CurrentTemperature = int.Parse(temperature);
        }
    }
}