﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter11.Listing11_22
{
    using System;
    using Listing11_13;

    public class BinaryTree<T>
        where T : System.IComparable<T>
    {
        public T Item { get; set; }

        public Pair<BinaryTree<T>> SubItems
        {
            get { return _SubItems; }
            set
            {
                IComparable<T> first;
                // Zauważ, że teraz można pominąć rzutowanie.
                first = value.First.Item;

                if(first.CompareTo(value.Second.Item) < 0)
                {
                    // Wartość właściwości First jest mniejsza niż wartość właściwości Second.
                    //...
                }
                else
                {
                    // Wartość właściwości Second jest mniejsza lub równa względem właściwości First.
                    //...
                }
                _SubItems = value;
            }
        }
        private Pair<BinaryTree<T>> _SubItems;

    }
}