namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter03.Listing03_50
{
    public class TicTacToe      // Deklaracja klasy TicTacToe. 
    {
        public static void Main()
        {
            int winner = 0;
            // Przechowuje pola wybrane przez poszczeglnych graczy.
            int[] playerPositions = { 0, 0 };

            // Zapisanie na sztywno pozycji na planszy.
            //  X | 2 | O 
            // ---+---+---
            //  O | O | 6 
            // ---+---+---
            //  X | X | X 
            playerPositions[0] = 449;
            playerPositions[1] = 28;

            // Wykrywanie wygranej jednego z graczy.
            int[] winningMasks = {
                7, 56, 448, 73, 146, 292, 84, 273 };

            // Sprawdzenie wszystkich masek oznaczajcych wygran, by 
            // ustali, czy ktry z graczy zwyciy.
            foreach (int mask in winningMasks)
            {
                if((mask & playerPositions[0]) == mask)
                {
                    winner = 1;
                    break;
                }
                else if((mask & playerPositions[1]) == mask)
                {
                    winner = 2;
                    break;
                }
            }

            System.Console.WriteLine(
                $"Zwyciy gracz nr { winner }.");
        }
    }
}