namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter16.Listing16_14
{
    using System;
    using Listing16_10;

    using System.Collections.Generic;

    public struct Pair<T> : IPair<T>,
    IEnumerable<T>
    {
        public Pair(T first, T second)
            : this()
        {
            First = first;
            Second = second;
        }
        public T First { get; }
        public T Second { get; }

        #region Indekser
        public T this[PairItem index]
        {
            get
            {
                switch(index)
                {
                    case PairItem.First:
                        return First;
                    case PairItem.Second:
                        return Second;
                    default:
                        throw new NotImplementedException(
                            string.Format(
                            "Wyliczenie nie zawiera wartoci {0}",
                            index.ToString()));
                }
            }
            #endregion Indekser
        }

        #region IEnumerable<T>
        public IEnumerator<T> GetEnumerator()
        {
            yield return First;
            yield return Second;
        }
        #endregion IEnumerable<T>

        #region Skadowe z interfejsu IEnumerable
        System.Collections.IEnumerator
            System.Collections.IEnumerable.GetEnumerator()
        {
            return GetEnumerator();
        }
        #endregion
    }
}