namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter16.Listing16_12
{
    using System.Collections;
    using System.Collections.Generic;

    public class BinaryTree<T> :
    IEnumerable<T>
    {
        public BinaryTree(T value)
        {
            Value = value;
        }

        #region IEnumerable<T>
        public IEnumerator<T> GetEnumerator()
        {
            // ...
            return new List<T>.Enumerator(); // Implementacj znajdziesz na listingu 16.16
        }
        IEnumerator IEnumerable.GetEnumerator()
        {
            // ...
            return GetEnumerator(); // Implementacj znajdziesz na listingu 16.16
        }
        #endregion IEnumerable<T>

        public T Value { get; }  // Automatycznie implementowana waciwo z samym getterem (kod dla wersji C# 6.0). 
        public Pair<BinaryTree<T>> SubItems { get; set; }
    }

    public struct Pair<T>
    {
        public Pair(T first, T second) : this()
        {
            First = first;
            Second = second;
        }
        public T First { get; }  // Automatycznie implementowana waciwo z samym getterem (kod dla wersji C# 6.0). 
        public T Second { get; } // Automatycznie implementowana waciwo z samym getterem (kod dla wersji C# 6.0). 

    }
}
