namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter16.Listing16_06
{
    using System;
    using System.Collections.Generic;

    public class Program
    {
        public static void Main()
        {
            // Kod dla wersji C# 6.0 (we wczeniejszych wersjach 
            // zastosuj skadni {"Error", ConsoleColor.Red})
            Dictionary<string, ConsoleColor> colorMap =
                new Dictionary<string, ConsoleColor>
                {
                    ["Error"] = ConsoleColor.Red,
                    ["Warning"] = ConsoleColor.Yellow,
                    ["Information"] = ConsoleColor.Green
                };

            colorMap["Verbose"] = ConsoleColor.White;
            colorMap["Error"] = ConsoleColor.Cyan;

            Print(colorMap);
        }

        private static void Print(IEnumerable<KeyValuePair<string, ConsoleColor>> items)
        {
            foreach (KeyValuePair<string, ConsoleColor> item in items)
            {
                Console.ForegroundColor = item.Value;
                Console.WriteLine(item.Key);
            }
        }
    }
}