﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter07.Listing07_10
{
    using System;
    using Listing07_02;

    class Program
    {
        public static void Main()
        {
            Contact[] contacts = new Contact[6];
            contacts[0] = new Contact(
                "Dick", "Traci",
                "123 Main St., Spokane, WA  99037",
                "123-123-1234");
            // ...

            // Klasy są niejawnie rzutowane na
            // zaimplementowane w nich interfejsy.
            contacts.List(Contact.Headers);

            Console.WriteLine();

            Publication[] publications = new Publication[3] {
                new Publication("Dyscypliny życia duchowego",
                    "Richard Foster", 1978),
                new Publication("Ortodoksja", 
                    "G.K. Chesterton", 1908),
                new Publication(
                    "Autostopem przez galaktykę",
                    "Douglas Adams", 1979)
                };
            publications.List(Publication.Headers);
        }
    }

    static class Listable
    {
        public static void List(
            this IListable[] items, string[] headers)
        {
            int[] columnWidths = DisplayHeaders(headers);

            for(int itemCount = 0; itemCount < items.Length; itemCount++)
            {
                string[] values = items[itemCount].ColumnValues;

                DisplayItemRow(columnWidths, values);
            }
        }

        /// <summary>Wyświetla nagłówki kolumn</summary>
        /// <returns>Zwraca tablicę szerokości kolumn</returns>
        private static int[] DisplayHeaders(string[] headers)
        {
            var columnWidths = new int[headers.Length];
            for(int index = 0; index < headers.Length; index++)
            {
                Console.Write(headers[index]);
                columnWidths[index] = headers[index].Length;
            }
            Console.WriteLine();
            return columnWidths;
        }

        private static void DisplayItemRow(
            int[] columnWidths, string[] values)
        {
            if(columnWidths.Length != values.Length)
            {
                throw new ArgumentOutOfRangeException(
                    $"{ nameof(columnWidths) },{ nameof(values) }",
                    "Liczba szereokości kolumn musi pasować do liczby wyświetlanych wartości");
            }

            for(int index = 0; index < values.Length; index++)
            {
                string itemToPrint = values[index].PadRight(columnWidths[index], ' ');
                Console.Write(itemToPrint);
            }
            Console.WriteLine();
        }
    }
}
