﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter07.Listing07_06
{
    interface IReadableSettingsProvider
    {
        string GetSetting(string name, string defaultValue);
    }

    interface ISettingsProvider : IReadableSettingsProvider
    {
        void SetSetting(string name, string value);
    }

    class FileSettingsProvider : ISettingsProvider
    {
        #region Składowe z interfejsu ISettingsProvider
        public void SetSetting(string name, string value)
        {
            // ...
        }
        #endregion

        #region Składowe z interfejsu IReadableSettingsProvider
        public string GetSetting(string name, string defaultValue)
        {
            return name + defaultValue; // Zwraca przykładowe dane
        }
        #endregion
    }

}
