﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter06.Listing06_14
{
    using System;

    public class Program
    {
        public class BaseClass
        {
            public void DisplayName()
            {
                Console.WriteLine("BaseClass");
            }
        }

        public class DerivedClass : BaseClass
        {
            // OSTRZEŻENIE kompilatora: metoda DisplayName() ukrywa odziedziczoną
            // składową. Jeśli jest to celowe, zastosuj słowo kluczowe new.
            public virtual void DisplayName()
            {
                Console.WriteLine("DerivedClass");
            }
        }

        public class SubDerivedClass : DerivedClass
        {
            public override void DisplayName()
            {
                Console.WriteLine("SubDerivedClass");
            }
        }

        public class SuperSubDerivedClass : SubDerivedClass
        {
            public new void DisplayName()
            {
                Console.WriteLine("SuperSubDerivedClass");
            }
        }

        public static void Main()
        {
            SuperSubDerivedClass superSubDerivedClass
                = new SuperSubDerivedClass();

            SubDerivedClass subDerivedClass = superSubDerivedClass;
            DerivedClass derivedClass = superSubDerivedClass;
            BaseClass baseClass = superSubDerivedClass;

            superSubDerivedClass.DisplayName();
            subDerivedClass.DisplayName();
            derivedClass.DisplayName();
            baseClass.DisplayName();
        }
    }
}
