﻿namespace AddisonWesley.Michaelis.EssentialCSharp.AppendixC.ListingC_07
{
    using System;
    using AddisonWesley.Michaelis.EssentialCSharp.Shared;

    public class Program
    {
        public static void Main()
        {
            Console.WriteLine("Uruchomiono aplikację...");

            Func<int, string> workerMethod = null;
            IAsyncResult asyncResult = null;

            workerMethod = PiCalculator.Calculate;
            Console.WriteLine("Uruchamianie wątku...");
            asyncResult =
                workerMethod.BeginInvoke(500, null, null);

            // Wyświetlanie kropek jako paska postępu.
            while (!asyncResult.AsyncWaitHandle.WaitOne(
                100, false))
            {
                Console.Write('.');
            }
            Console.WriteLine();
            Console.WriteLine("Kończenie pracy wątku...");
            Console.WriteLine(
                workerMethod.EndInvoke(asyncResult));

            Console.WriteLine("Zamykanie aplikacji...");
        }
    }
}






