﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter14.Listing14_23
{
    using System;
    using System.Collections.Generic;
    using System.Linq;

    public class Program
    {
        public static void Main()
        {
            Department[] departments = CorporateData.Departments;
            Employee[] employees = CorporateData.Employees;

            var items = departments.Join(
                employees,
                department => department.Id,
                employee => employee.DepartmentId,
                (department, employee) => new
                {
                    department.Id,
                    department.Name,
                    Employee = employee
                });

            foreach(var item in items)
            {
                Console.WriteLine(item.Name);
                Console.WriteLine("\t" + item.Employee);
            }

        }

        private static void Print<T>(IEnumerable<T> items)
        {
            foreach(T item in items)
            {
                Console.WriteLine(item);
            }
        }
    }

    public class Department
    {
        public long Id { get; set; }
        public string Name { get; set; }
        public override string ToString()
        {
            return Name;
        }
    }

    public class Employee
    {
        public int Id { get; set; }
        public string Name { get; set; }
        public string Title { get; set; }
        public int DepartmentId { get; set; }
        public override string ToString()
        {
            return $"{ Name } ({ Title })";
        }
    }

    public static class CorporateData
    {
        public static readonly Department[] Departments =
            new Department[]
        {
            new Department()
            {
                Name = "Dział korporacyjny",
                Id = 0
            },
            new Department()
            {
                Name = "Dział finansów",
                Id = 1
            },
            new Department()
            {
                Name = "Dział inżynierii",
                Id = 2
            },
            new Department()
            {
                Name = "Dział IT",
                Id = 3
            },
            new Department()
            {
                Name = "Dział filantropii",
                Id = 4
            },
            new Department()
            {
                Name = "Dział marketingu",
                Id = 5
            },
        };

        public static readonly Employee[] Employees = new Employee[]
        {
            new Employee()
            {
                Name = "Mark Michaelis",
                Title = "Główny nerd",
                DepartmentId = 0
            },
            new Employee()
            {
                Name = "Michael Stokesbary",
                Title = "Starszy geniusz komputerowy",
                DepartmentId = 2
            },
            new Employee()
            {
                Name = "Brian Jones",
                Title = "Guru od integracji systemów",
                DepartmentId = 2
            },
            new Employee()
            {
                Name = "Shane Kercheval",
                Title = "CFO",
                DepartmentId = 1
            },
            new Employee()
            {
                Name = "Pat Dever",
                Title = "Architekt systemów korporacyjnych",
                DepartmentId = 3
            },
            new Employee()
            {
                Name = "Kevin Bost",
                Title = "Programista nadzwyczajny",
                DepartmentId = 2
            },
            new Employee()
            {
                Name = "Thomas Heavey",
                Title = "Architekt oprogramowania",
                DepartmentId = 2
            },
            new Employee()
            {
                Name = "Eric Edmonds",
                Title = "Koordynator działań charytatywnych",
                DepartmentId = 4
            }
        };
    }
}