#include <sys/types.h>
#include <limits.h>
#include <sys/stat.h>
#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <paths.h>

#ifndef OPEN_MAX
#define OPEN_MAX 256
#endif

static int open_devnull(int fd) {
  FILE *f = 0;

  if (!fd) f = freopen(_PATH_DEVNULL, "rb", stdin);
  else if (fd == 1) f = freopen(_PATH_DEVNULL, "wb", stdout);
  else if (fd == 2) f = freopen(_PATH_DEVNULL, "wb", stderr);
  return (f && fileno(f) == fd);
}

void spc_sanitize_files(void) {
  int         fd, fds;
  struct stat st;

  /* Upewnij si, e wszystkie otwarte deskryptory (poza trzema standardowymi)
   * s zamknite.
   */
  if ((fds = getdtablesize()) == -1) fds = OPEN_MAX;
  for (fd = 3;  fd < fds;  fd++) close(fd);

  /* Sprawd, czy standardowe deskryptory s otwarte. Jeli nie, sprbuj je
   * otworzy za pomoc urzdzenia /dev/null. Jeli otwarcie ktregokolwiek z
   * z tych deskryptorw si nie powiedzie, zakocz prac programu.
   */
  for (fd = 0;  fd < 3;  fd++)
    if (fstat(fd, &st) == -1 && (errno != EBADF || !open_devnull(fd))) abort();
}

