#include <stdio.h>
#include <signal.h>
#include <unistd.h>

volatile sig_atomic_t sigint_received = 0;
volatile sig_atomic_t sigterm_received = 0;
volatile sig_atomic_t sigquit_received = 0;

void handle_sigint(int sig)  { sigint_received = 1;  }
void handle_sigterm(int sig) { sigterm_received = 1; }
void handle_sigquit(int sig) { sigquit_received = 1; }

static void setup_signal_handler(int sig, void (*handler)( )) {
#if _POSIX_VERSION > 198800L
  struct sigaction action;

  action.sa_handler = handler;
  sigemptyset(&(action.sa_mask));
  sigaddset(&(action.sa_mask), sig);
  action.sa_flags = 0;
  sigaction(sig, &action, 0);
#else
  signal(sig, handler);
#endif
}

static int signal_was_caught(void)
{
  if (sigint_received) printf("Otrzymano sygna SIGINT!\n");
  if (sigterm_received) printf("Otrzymano sygna SIGTERM!\n");
  if (sigquit_received) printf("Otrzymano sygna SIGQUIT!\n");
  return (sigint_received || sigterm_received || sigquit_received);
}

int main(int argc, char *argv[]) {
  char buffer[80];

  setup_signal_handler(SIGINT, handle_sigint);
  setup_signal_handler(SIGTERM, handle_sigterm);
  setup_signal_handler(SIGQUIT, handle_sigquit);

  /* Ptla gwna niniejszego programu odczytuje po prostu dane ze
   * standardowego wejcia i odrzuca je. Taka funkcjonalno jest
   * bezuyteczna, jednak naszym celem jest przedstawienie mechanizmu
   * obsugi sygnaw, a fread to funkcja systemowa, ktra jest przerywana
   * sygnaami, wic doskonale nadaje si do celw pogldowych.
   */
  while (!feof(stdin)) {
    fread(buffer, 1, sizeof(buffer), stdin);
    if (signal_was_caught()) break;
  }

  return (sigint_received || sigterm_received || sigquit_received);
}

