BOOL           bResult;
HCERTSTORE     hCertStore;
PCCRL_CONTEXT  pCRLContext;
PCCERT_CONTEXT pCertContext = 0;

if (!(hCertStore = SpcNewStoreForCert(pSubjectContext))) {
  /* obsuga bdu - nie mona utworzy magazynu */
  abort();
}
while ((pCertContext = CertEnumCertificatesInStore(hCertStore, pCertContext))) {
  /* Wykonaj pewne operacje na certyfikacie pobranym z magazynu.
   * Jeeli wystpi bd, a wyliczenie musi zosta zakoczone przedwczenie,
   * ostatni pobrany certyfikat musi zosta zwolniony rcznie.
   *
   * Przykadowo, sprbuj pobra list CRL dla certyfikatu uywajc kodu
   * z receptury 10.11. Jeeli nie bdzie mona pobra adnej listy CRL lub
   * listy nie bdzie mona doda do magazynu certyfikatw, naley to traktowa
   * jako bd i zakoczy wyliczanie.
   */
  if (!(pCRLContext = SpcRetrieveCRL(pCertContext, 0)) ||
      !CertAddCRLContextToStore(hCertStore, pCRLContext,
                                CERT_ADD_USE_EXISTING, 0)) {
    if (pCRLContext) CertFreeCRLContext(pCRLContext);
    break;
  }
  CertFreeCRLContext(pCRLContext);
}
if (pCertContext) {
  CertFreeCertificateContext(pCertContext);
  CertCloseStore(hCertStore, 0);
  abort();
}
bResult = SpcVerifyCert(hCertStore, pSubjectContext);
CertCloseStore(hCertStore, 0);
return bResult;

