unsigned char *spc_server_read(spc_ssock_t *ctx,  size_t *len, size_t *end) {
  unsigned char nonce[SPC_CWC_NONCE_LEN], status;

  /* Jeeli kolej serwer na nadawanie, anulujemy. Wiemy, e kolej serwera na
   * nadawanie, jeeli pierwszy bajt identyfikatora jednorazowego ma warto
   * elementu wyrniajcego CLIENT.
   */
  if (ctx->nonce[0] != SPC_SERVER_DISTINGUISHER &&
      ctx->nonce[0] != SPC_SERVER_LACKS_NONCE) abort();

  spc_get_status_and_nonce(ctx->fd, &status, nonce);
  *end = status;

  /* Jeeli to konieczne, kopiujemy losowy bajt identyfikatora jednorazowego. */
  if (ctx->nonce[0] == SPC_SERVER_LACKS_NONCE)
    memcpy(ctx->nonce + SPC_IV_IX, nonce + SPC_IV_IX, SPC_IV_LEN);

  /* Teraz ustawiamy pole wyrniajce na klienta i zwikszamy o jeden nasz
   * kopi identyfikatora jednorazowego.
   */
  ctx->nonce[0] = SPC_CLIENT_DISTINGUISHER;
  spc_increment_counter(ctx->nonce + SPC_CTR_IX, SPC_CTR_LEN);

  return spc_finish_decryption(ctx, status, nonce, len);
}

