#include <stdarg.h>
#include <stdio.h>

#if defined(__GNUC__) && defined(i386)
/* UWAGA: poniszy kod dziaa poprawnie wycznie w przypadku uywania 
 * kompilatora GCC na maszynie z procesorem z rodziny x86
 */

#define spc_next_varg(ap, type, var) \
  do { \
    unsigned int __frame; \
    __frame = *(unsigned int *)__builtin_frame_address(0); \
    if ((unsigned int)(ap) == __frame - 16) { \
      fprintf(stderr, "funkcja spc_next_varg() wywoana zbyt wiele razy!\n"); \
      abort(); \
    } \
    (var) = va_arg((ap), (type)); \
  } while (0)

#define VARARG_CALL_1(func, a1)                             \
  func((a1))
#define VARARG_CALL_2(func, a1, a2)                         \
  func((a1), (a2))
#define VARARG_CALL_3(func, a1, a2, a3)                     \
  func((a1), (a2), (a3))
#define VARARG_CALL_4(func, a1, a2, a3, a4)                 \
  func((a1), (a2), (a3), (a4))
#define VARARG_CALL_5(func, a1, a2, a3, a4, a5)             \
  func((a1), (a2), (a3), (a4), (a5))
#define VARARG_CALL_6(func, a1, a2, a3, a4, a5, a6)         \
  func((a1), (a2), (a3), (a4), (a5), (a6))
#define VARARG_CALL_7(func, a1, a2, a3, a4, a5, a6, a7)     \
  func((a1), (a2), (a3), (a4), (a5), (a6), (a7))
#define VARARG_CALL_8(func, a1, a2, a3, a4, a5, a6, a7, a8) \
  func((a1), (a2), (a3), (a4), (a5), (a6), (a7), (a8))

#else
/* UWAGA: poniszy kod powinien dziaa poprawnie w przypadku dowolnej maszyny
 * i kompilatora
 */

#define VARARG_MAGIC    0xDEADBEEF

#define spc_next_varg(ap, type, var) \
  do { \
    (var) = va_arg((ap), (type)); \
    if ((int)(var) == VARARG_MAGIC) { \
      fprintf(stderr, "funkcja spc_next_varg() wywoana zbyt wiele razy!\n"); \
      abort(); \
    } \
  } while (0)

#define VARARG_CALL_1(func, a1)                             \
  func((a1), VARARG_MAGIC)
#define VARARG_CALL_2(func, a1, a2)                         \
  func((a1), (a2), VARARG_MAGIC)
#define VARARG_CALL_3(func, a1, a2, a3)                     \
  func((a1), (a2), (a3), VARARG_MAGIC)
#define VARARG_CALL_4(func, a1, a2, a3, a4)                 \
  func((a1), (a2), (a3), (a4), VARARG_MAGIC)
#define VARARG_CALL_5(func, a1, a2, a3, a4, a5)             \
  func((a1), (a2), (a3), (a4), (a5), VARARG_MAGIC)
#define VARARG_CALL_6(func, a1, a2, a3, a4, a5, a6)         \
  func((a1), (a2), (a3), (a4), (a5), (a6), VARARG_MAGIC)
#define VARARG_CALL_7(func, a1, a2, a3, a4, a5, a6, a7)     \
  func((a1), (a2), (a3), (a4), (a5), (a6), (a7), VARARG_MAGIC)
#define VARARG_CALL_8(func, a1, a2, a3, a4, a5, a6, a7, a8) \
  func((a1), (a2), (a3), (a4), (a5), (a6), (a7), (a8), VARARG_MAGIC)

#endif

