#include <stdlib.h>
#include <limits.h>

/* Utworzenie podzielonej tablicy elementw num_elem, kadego o rozmiarze sz_elem */
spc_array_t *spc_array_split(int sz_elem, int num_elem) {
  double      size;
  spc_array_t *a;

  size = (((double)sz_elem * (double)num_elem) / 2) + (double)sizeof(spc_array_t);
  if (size > (double)INT_MAX) return 0;
  if (!(a = (spc_array_t *)calloc((size_t)size, 1))) return 0;
  a->type     = SPC_ARRAY_SPLIT;
  a->sz_elem  = sz_elem;
  a->num_elem = num_elem;
  a->split    = 2; /* tablica zostaje podzielona na dwie 2 tablice */
  return a;
}

/* Utworzenie dwch scalonych tablic z num_first elementami w tablicy 1 oraz num_second
 * elementami w tablicy 2
 */
spc_array_t *spc_array_merge(int sz_elem, int num_first, int num_second) {
  double      size;
  spc_array_t *a;

  size = (((double)num_first + (double)num_second) * (double)sz_elem) +
         (double)sizeof(spc_array_t);
  if (!num_first || size > (double)INT_MAX) return 0;
  if (!(a =  (spc_array_t *)calloc((size_t)size, 1))) return 0;
  a->type     = SPC_ARRAY_MERGE;
  a->sz_elem  = sz_elem;
  a->num_elem = num_first + num_second;
  a->split    = num_first / num_second;
  if (!a->split) a->split = (num_second / num_first) * -1;
  return a;
}

/* Utworzenie tablicy zoonej 'layers' razy, liczcej num_elem elementw */
spc_array_t *spc_array_fold(int sz_elem, int num_elem, int layers) {
  double      size = (sz_elem * num_elem) + sizeof(spc_array_t);
  spc_array_t *a;

  size = ((double)sz_elem * (double)num_elem) + (double)sizeof(spc_array_t);
  if (size > (double)INT_MAX) return 0;
  if (!(a = (spc_array_t *)calloc((size_t)size, 1))) return 0;
  a->type     = SPC_ARRAY_FOLD;
  a->sz_elem  = sz_elem;
  a->num_elem = num_elem;
  a->split    = layers;

  return a;
}

/* Utworzenie spaszczonej tablicy o num_dimen wymiarach z num_elem elementami na
 * wymiar, spaszczonymi do jednego wymiaru
 */
spc_array_t *spc_array_flat(int sz_elem, int num_elem, int num_dimen) {
  double      size;
  spc_array_t *a;

  size = ((double)sz_elem * (double)num_elem * (double)num_dimen) +
         (double)sizeof(spc_array_t);
  if (size > (double)INT_MAX) return 0;
  if (!(a = (spc_array_t *)calloc((size_t)size, 1))) return 0;
  a->type     = SPC_ARRAY_FLAT;
  a->sz_elem  = sz_elem;
  a->num_elem = num_elem * num_dimen;
  a->split    = num_dimen;

  return a;
}

/* zwrcenie prawdziwego indeksu elementu 'idx' w tablicy 'subarray' */
static int array_index(spc_array_t *a, int subarray, int idx) {
  int index = -1, num_row, diff;

  num_row = a->num_elem / a->split;
  switch (a->type) {
    case SPC_ARRAY_SPLIT:
      if (idx % a->split) index = idx / a->split;
      else index = (a->num_elem / a->split) + (idx / a->split);
      break;
    case SPC_ARRAY_MERGE:
      /* a->split == rznica rozmiarw midzy tablic 1 a 2 */
      if (a->split < 0) {
        subarray = !subarray;
        diff = a->split * -1;
      } else diff = a->split;
      if (!subarray) index = idx + idx / diff;
      else index = diff + (idx * (diff + 1));
      break;
    case SPC_ARRAY_FOLD:
      index = (idx / num_row) + (a->split * (idx % num_row) );
      break;
    case SPC_ARRAY_FLAT:
      index = subarray + (a->split * (idx % num_row));
      break;
  }
  return (index >= a->num_elem ? -1 : index);
}

/* Pobranie wskanika do elementu 'idx' w tablicy 'subarray' */
void *spc_array_get(spc_array_t *a, int subarray, int idx) {
  int index;

  if (!a || (index = array_index(a, subarray, idx)) == -1) return 0;
  return (void *)(a->data + (a->sz_elem * index));
}

/* Ustawienie elementu 'idx' w tablicy 'subarray' na dane, na ktrej wskazuje 'src'.
 * Naley zauway, e warto sz_elem uywana do inicjalizacji tablicy jest tu
 * wykorzystywana w celu skopiowania poprawnej iloci danych.
 */
int spc_array_set(spc_array_t *a, int subarray, int idx, void *src) {
  int index;

  if (!a || !src || (index = array_index(a, subarray, idx)) == -1)
    return 0;
  memcpy(a->data + (a->sz_elem * index), src, a->sz_elem);
  return 1;
}

/* Zwolnienie zmiennej typu spc_array_t, w tym jej tabeli elementw */
int spc_array_free(spc_array_t *a) {
  if (a) free(a);
  return !!a;
}

