int spc_cbc_encrypt_update(SPC_CBC_CTX *ctx, unsigned char *in, size_t il,
                           unsigned char *out, size_t *ol) {
  /* Przechowuje wskanik do in, ktry pniej zwikszymy; warto ol bdziemy
   * wyznaczali w dalszej kolejnoci przez odpowiedni operacj odejmowania.
   */
  int           i;
  unsigned char *start = out;

  /* Jeli mamy jakie pozostaoci, ktrych jest jednak zbyt mao, aby wypeni
   * cay blok, czymy je za pomoc operacji XOR z odpowiednimi bajtami wektora
   * inicjalizacji i zwracamy otrzymany wynik. Ewentualne pozostaoci nie mog
   * by zbyt dugie, zatem przetwarzanie po jednym bajcie na iteracj w zupenoci
   * wystarczy.
   */
  if (il < SPC_BLOCK_SZ-ctx->ix) {
    while (il--) ctx->iv[ctx->ix++] ^= *in++;
    if (ol) *ol = 0;
    return 1;
  }

  /* Jeli mielimy jakie pozostaoci i znaleli si w tym miejscu, powinnimy
   * wypeni dany blok i przekaza na wyjcie gotowy szyfrogram.
   */
  if (ctx->ix) {
    while (ctx->ix < SPC_BLOCK_SZ) --il, ctx->iv[ctx->ix++] ^= *in++;
    SPC_DO_ENCRYPT(&(ctx->ks), ctx->iv, ctx->iv);
    for (i = 0;  i < SPC_BLOCK_SZ / sizeof(int);  i++)
      ((unsigned int *)out)[i] = ((unsigned int *)(ctx->iv))[i];
    out += SPC_BLOCK_SZ;
  }

  /* Dziaamy na fragmentach dugoci sowa, poniewa takie rozwizanie jest
   * najprostsze. Moemy uzyska wiele cykli na jedn iteracj ptli przez
   * zawijanie oraz zwalnianie indeksu i w przypadku, gdy z gry znamy
   * rozmiar danego sowa.
   */
  while (il >= SPC_BLOCK_SZ) {
    for (i = 0;  i < SPC_BLOCK_SZ / sizeof(int);  i++)
      ((unsigned int *)(ctx->iv))[i] ^= ((unsigned int *)in)[i];
    SPC_DO_ENCRYPT(&(ctx->ks), ctx->iv, ctx->iv);
    for (i = 0;  i < SPC_BLOCK_SZ / sizeof(int);  i++)
      ((unsigned int *)out)[i] = ((unsigned int *)(ctx->iv))[i];
    out += SPC_BLOCK_SZ;
    in  += SPC_BLOCK_SZ;
    il  -= SPC_BLOCK_SZ;
  }

  /* Obsuga pozostaoci... take w tym przypadku przetwarzanie po jednym
   * bajcie na iteracj jest rozwizaniem wystarczajcym.
   */
  for (i = 0;  i < il;  i++) ctx->iv[i] ^= in[i];
  ctx->ix = il;
  if (ol) *ol = out-start;
  return 1;
}

