// ZODIACIMPL.H : Declaration of the TZodiacImpl

#ifndef ZodiacImplH
#define ZodiacImplH

#include "ZodiacServer_TLB.H"

// For firing custom events:
template <class T>
class TEvents_DetailedZodiac :
   public IConnectionPointImpl<T,
           &IID_IDetailedZodiacEvents,
           CComDynamicUnkArray>
{
   public:
   HRESULT Fire_OnDetailedZodiacSignReady(TDetailedZodiacSign* DetailedSign)
   {
      T * pT = (T*)this;
      pT->Lock();
      IUnknown ** pp = m_vec.begin();
      while (pp < m_vec.end())
      {
         if (*pp != NULL)
         {
         /*
            CComPtr<IUnknown> sp = *pp;
            IDetailedZodiacEvents* pEvents =
               static_cast<IDetailedZodiacEvents*>(sp.p);
            if (pEvents != NULL)
               pEvents->OnDetailedZodiacSignReady(DetailedSign);
         */
            CComQIPtr<IDetailedZodiacEvents, &IID_IDetailedZodiacEvents> ptrEvents = *pp;
            if (ptrEvents != NULL)
               ptrEvents->OnDetailedZodiacSignReady(DetailedSign);
         }
         pp++;
     }
     pT->Unlock();

     return S_OK;
   }
};

/////////////////////////////////////////////////////////////////////////////
// TZodiacImpl     Implements IZodiac, default interface of Zodiac
//                  and IZodiacEvents, the default source interface
// ThreadingModel : Free
// Dual Interface : FALSE
// Event Support  : TRUE
// Default ProgID : ZodiacServer.Zodiac
// Description    : A very simple Zodiac server
/////////////////////////////////////////////////////////////////////////////
class ATL_NO_VTABLE TZodiacImpl : 
  public CComObjectRootEx<CComMultiThreadModel>,
  public CComCoClass<TZodiacImpl, &CLSID_Zodiac>,
  public IConnectionPointContainerImpl<TZodiacImpl>,
  public TEvents_Zodiac<TZodiacImpl>,
  public IDispatchImpl<IZodiac, &IID_IZodiac, &LIBID_ZodiacServer>,
  public TEvents_DetailedZodiac<TZodiacImpl>,
  public ISupportErrorInfo,
  public IDetailedZodiac //DUALINTERFACE_IMPL(Zodiac, IDetailedZodiac)
{
public:
  TZodiacImpl()
  {
  }

  // Dane uywane podczas rejestraacji
  //
  DECLARE_THREADING_MODEL(otFree);
  DECLARE_PROGID("ZodiacServer.Zodiac");
  DECLARE_DESCRIPTION("Prosty serwer astrologiczny");

  // Rejestracja i wyrejestrowanie
  //
  static HRESULT WINAPI UpdateRegistry(BOOL bRegister)
  {
    TTypedComServerRegistrarT<TZodiacImpl> 
    regObj(GetObjectCLSID(), GetProgID(), GetDescription());
    return regObj.UpdateRegistry(bRegister);
  }

BEGIN_COM_MAP(TZodiacImpl)
  COM_INTERFACE_ENTRY(IZodiac)
  COM_INTERFACE_ENTRY2(IDispatch, IZodiac)
  COM_INTERFACE_ENTRY(IDetailedZodiac)//DUALINTERFACE_ENTRY(IDetailedZodiac)
  COM_INTERFACE_ENTRY_IMPL(IConnectionPointContainer)
  COM_INTERFACE_ENTRY(ISupportErrorInfo)
END_COM_MAP()

BEGIN_CONNECTION_POINT_MAP(TZodiacImpl)
  CONNECTION_POINT_ENTRY(DIID_IZodiacEvents)
  CONNECTION_POINT_ENTRY(IID_IDetailedZodiacEvents)
END_CONNECTION_POINT_MAP()

// ISupportErrorInfo
public:
	STDMETHOD(InterfaceSupportsErrorInfo)(REFIID riid);

// IZodiac
public:
  STDMETHOD(GetZodiacSign(long Day, long Month, BSTR* Sign));
  STDMETHOD(GetZodiacSignAsync(long Day, long Month));
// IDetailedZodiac
  STDMETHOD(GetDetailedZodiacSign(long Day, long Month,
      TDetailedZodiacSign* DetailedSign));
  STDMETHOD(GetDetailedZodiacSignAsync(long Day, long Month));
};

#endif //ZodiacImplH
