#if !defined(ZODIACSINK_H__)
#define ZODIACSINK_H__

#include <atlvcl.h>
#include <atlbase.h>
#include <atlcom.h>
#include <ComObj.HPP>
#include <utilcls.h>
#include "ZodiacServer_TLB.h"

typedef void __fastcall (__closure * TZodiacSignReadyEvent)(BSTR Sign);

//---------------------------------------------------------------------------
// Klasa obsugujca interfejs IZodiacEvents
class TZodiacSink :
   public TEventDispatcher<TZodiacSink, &DIID_IZodiacEvents>
{
protected:
  // Zdarzenie
  TZodiacSignReadyEvent FOnZodiacSignReady;

  // Dystrybutor zdarze
  HRESULT InvokeEvent(DISPID id, TVariant* params)
  {
      if ((id == 1) && (FOnZodiacSignReady != NULL)) // OnZodiacSignReady
        FOnZodiacSignReady(params[0]);
      return S_OK;
  }

  // Referencja do rda zdarzenia
  CComPtr<IUnknown> m_pSender;

public:
  __property TZodiacSignReadyEvent OnZodiacSignReady =
    { read = FOnZodiacSignReady, write = FOnZodiacSignReady };

public:
  TZodiacSink() :
     m_pSender(NULL),
     FOnZodiacSignReady(NULL)
  {
  }

  virtual ~TZodiacSink()
  {
     Disconnect();
  }

  // Poczenie z serwerem
  void Connect(IUnknown* pSender)
  {
     if (pSender != m_pSender)
        m_pSender = pSender;
     if (NULL != m_pSender)
       ConnectEvents(m_pSender);
  }

  // Odczenie od serwera
  void Disconnect()
  {
    if (NULL != m_pSender)
    {
      DisconnectEvents(m_pSender);
      m_pSender = NULL;
    }
  }
};

#endif //ZODIACSINK_H__

