//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Main.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TMainForm *MainForm;
//---------------------------------------------------------------------------
__fastcall TMainForm::TMainForm(TComponent* Owner)
  : TForm(Owner)
{
  ShortDateFormat = _T("mm/dd/yyyy");
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::OnZodiacSignReady(BSTR Sign)
{
    WideString wstrSign = Sign;
    memLog->Lines->Add(_T("Znak zodiaku (asynchronicznie):"));
    memLog->Lines->Add(_T("  ") + wstrSign);
    memLog->Lines->Add(_T(""));
    wstrSign.Detach();
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::OnDetailedZodiacSignReady(
                    TDetailedZodiacSign& DetailedSign)
{
    memLog->Lines->Add(_T("Informacje szczegowe (asynchronicznie):"));
    memLog->Lines->Add(_T("  Znak = ") + AnsiString(DetailedSign.Sign));
    memLog->Lines->Add(_T("  Dom = ") + IntToStr(DetailedSign.House));
    memLog->Lines->Add(_T("  ywio = ") + AnsiString(DetailedSign.Element));
    memLog->Lines->Add(_T("  Planeta = ") + AnsiString(DetailedSign.Planet));
    memLog->Lines->Add(_T("  Szczegy = ") + AnsiString(DetailedSign.Details));
    memLog->Lines->Add(_T("  Rady = ") + AnsiString(DetailedSign.Advice));
    memLog->Lines->Add(_T(""));
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FormCreate(TObject *Sender)
{
  FZodiac = CoZodiac::Create();

  // Podcz zdarzenia standardowe.
  FZodiacSink.OnZodiacSignReady = OnZodiacSignReady;
  FZodiacSink.Connect(FZodiac);

  // Podcz zdarzenia niestandardowe.
  FZodiacCustomSink.OnDetailedZodiacSign = OnDetailedZodiacSignReady;
  FZodiacCustomSink.Connect(FZodiac);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::btnZodiacClick(TObject *Sender)
{
  TDateTime TheDate(FCalendar->Date);
  unsigned short year = 0;
  unsigned short month = 0;
  unsigned short day = 0;
  TheDate.DecodeDate(&year, &month, &day);
  if (!chkAsync->Checked)
  {
    BSTR bstrSign = FZodiac.GetZodiacSign(day, month); // Uyj otoczki!
    WideString wstrSign = bstrSign;

    memLog->Lines->Add(_T("Znak zodiaku:"));
    memLog->Lines->Add(_T("  ") + wstrSign);
    memLog->Lines->Add(_T(""));
  }
  else
  {
    OLECHECK(
      FZodiac.GetZodiacSignAsync(day, month));
  }
}
//---------------------------------------------------------------------------
struct TDetailedZodiacSignImpl : public TDetailedZodiacSign
{
   TDetailedZodiacSignImpl()
   {
      Sign = NULL;
      Element = NULL;
      Element = NULL;
      Planet = NULL;
      Details = NULL;
      Details = NULL;
      Advice = NULL;
   }
   ~TDetailedZodiacSignImpl()
   {
      if (Sign != NULL)
        SysFreeString(Sign);
      if (Element != NULL)
        SysFreeString(Element);
      if (Planet != NULL)
        SysFreeString(Planet);
      if (Details != NULL)
        SysFreeString(Details);
      if (Advice != NULL)
        SysFreeString(Advice);
   }
};

void __fastcall TMainForm::btnDetailedZodiacClick(TObject *Sender)
{
  TDateTime TheDate(FCalendar->Date);
  unsigned short year = 0;
  unsigned short month = 0;
  unsigned short day = 0;
  TheDate.DecodeDate(&year, &month, &day);
  // Niejawne wywoanie QueryInterface()
  IDetailedZodiacPtr DetailedZodiac = FZodiac;
  if (!chkAsync->Checked)
  {
    TDetailedZodiacSignImpl DetailedSign;
    OLECHECK(
      DetailedZodiac->GetDetailedZodiacSign(day, month, &DetailedSign));

    memLog->Lines->Add(_T("Informacje szczegowe:"));
    memLog->Lines->Add(_T("  Znak = ") + AnsiString(DetailedSign.Sign));
    memLog->Lines->Add(_T("  Dom = ") + IntToStr(DetailedSign.House));
    memLog->Lines->Add(_T("  ywio = ") + AnsiString(DetailedSign.Element));
    memLog->Lines->Add(_T("  Planeta = ") + AnsiString(DetailedSign.Planet));
    memLog->Lines->Add(_T("  Szczegy = ") + AnsiString(DetailedSign.Details));
    memLog->Lines->Add(_T("  Rady = ") + AnsiString(DetailedSign.Advice));
    memLog->Lines->Add(_T(""));
    memLog->Lines->Add(_T(""));
  }
  else
  {
    OLECHECK(
      DetailedZodiac->GetDetailedZodiacSignAsync(day, month));
  }
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::btnClearClick(TObject *Sender)
{
  memLog->Lines->Clear();
}
//---------------------------------------------------------------------------


void __fastcall TMainForm::FormClose(TObject *Sender, TCloseAction &Action)
{
  FZodiacSink.Release();
  FZodiacCustomSink.Release();
  FZodiac.Release();
  CoUninitialize();
}
//---------------------------------------------------------------------------

