// HostInfoImpl.h : Declaration of the THostInfoImpl

#ifndef HostInfoImplH
#define HostInfoImplH

#include "EasyDCOM_TLB.H"


/////////////////////////////////////////////////////////////////////////////
// THostInfoImpl     Implements IHostInfo, default interface of HostInfo
// ThreadingModel : Apartment
// Dual Interface : TRUE
// Event Support  : FALSE
// Default ProgID : EasyDCOM.HostInfo
// Description    : Easy DCOM Type Library 1.0
/////////////////////////////////////////////////////////////////////////////
class ATL_NO_VTABLE THostInfoImpl :
  public CComObjectRootEx<CComSingleThreadModel>,
  public CComCoClass<THostInfoImpl, &CLSID_HostInfo>,
  public IDispatchImpl<IHostInfo, &IID_IHostInfo, &LIBID_EasyDCOM>
{
public:
  THostInfoImpl()
  {
  }

  // Dane uywane podczas rejestracji
  //
  DECLARE_THREADING_MODEL(otApartment);
  DECLARE_PROGID("EasyDCOM.HostInfo");
  DECLARE_DESCRIPTION("Easy DCOM - wersja 1.0");

  // Rejestracja i wyrejestrowanie
  //
  static HRESULT WINAPI UpdateRegistry(BOOL bRegister)
  {
    TTypedComServerRegistrarT<THostInfoImpl>
    regObj(GetObjectCLSID(), GetProgID(), GetDescription());
    return regObj.UpdateRegistry(bRegister);
  }


BEGIN_COM_MAP(THostInfoImpl)
  COM_INTERFACE_ENTRY(IHostInfo)
  COM_INTERFACE_ENTRY2(IDispatch, IHostInfo)
END_COM_MAP()

// IHostInfo
public:
  STDMETHOD(get_Info(BSTR* Value));
};

#endif //HostInfoImplH

