// ObjBlanketImpl.H : Declaration of the TObjBlanketImpl

#ifndef ObjBlanketImplH
#define ObjBlanketImplH

#include "Blanket_TLB.H"


/////////////////////////////////////////////////////////////////////////////
// TObjBlanketImpl     Implements IObjBlanket, default interface of ObjBlanket
// ThreadingModel : Apartment
// Dual Interface : TRUE
// Event Support  : FALSE
// Default ProgID : Blanket.ObjBlanket
// Description    : Blanket Server Type Library 1.0
/////////////////////////////////////////////////////////////////////////////
class ATL_NO_VTABLE TObjBlanketImpl :
  public CComObjectRootEx<CComSingleThreadModel>,
  public CComCoClass<TObjBlanketImpl, &CLSID_ObjBlanket>,
  public IDispatchImpl<IObjBlanket, &IID_IObjBlanket, &LIBID_Blanket>
{
public:
  TObjBlanketImpl()
  {
  }

  // Dane uywaned podczas rejestracji
  //
  DECLARE_THREADING_MODEL(otApartment);
  DECLARE_PROGID("Blanket.ObjBlanket");
  DECLARE_DESCRIPTION("Blanket (serwer) - wersja 1.0");

  // Rejestracja i wyrejestrowanie
  //
  static HRESULT WINAPI UpdateRegistry(BOOL bRegister)
  {
    TTypedComServerRegistrarT<TObjBlanketImpl>
    regObj(GetObjectCLSID(), GetProgID(), GetDescription());
    return regObj.UpdateRegistry(bRegister);
  }


BEGIN_COM_MAP(TObjBlanketImpl)
  COM_INTERFACE_ENTRY(IObjBlanket)
  COM_INTERFACE_ENTRY2(IDispatch, IObjBlanket)
END_COM_MAP()

// IObjBlanket
public:
  STDMETHOD(BlanketInfo(BSTR* Value));
  STDMETHOD(CreateFile(BSTR Value));
};

#endif //ObjBlanketImplH

