// ObjBlanketImpl: Implementation of TObjBlanketImpl (CoClass: ObjBlanket, Interface: IObjBlanket)

#include <vcl.h>
#include <atl\atlcom.h>
#pragma hdrstop

#include "ObjBlanketImpl.h"

/////////////////////////////////////////////////////////////////////////////
// TObjBlanketImpl

STDMETHODIMP TObjBlanketImpl::BlanketInfo(BSTR* Value)
{
	try {
		*Value = NULL;
        LPWSTR pPrivs;

        OleCheck(CoQueryClientBlanket(NULL, NULL, NULL, NULL, NULL,
                                      (LPVOID*)&pPrivs, NULL));

        WideString strInfo = pPrivs;
		*Value = strInfo.Detach();
	}
	catch(Exception &e) {
		return Error(e.Message.c_str(), IID_IObjBlanket);
	}
	return S_OK;
};

STDMETHODIMP TObjBlanketImpl::CreateFile(BSTR Value)
{
	try {
        OleCheck(CoImpersonateClient());

        HANDLE hFile = ::CreateFile(AnsiString(Value).c_str(),
                                    GENERIC_WRITE,
                                    FILE_SHARE_WRITE,
                                    NULL,
                                    CREATE_ALWAYS,
                                    FILE_ATTRIBUTE_NORMAL,
                                    NULL);

        if (INVALID_HANDLE_VALUE == hFile)
            return HRESULT_FROM_WIN32(GetLastError());

        CloseHandle(hFile);
        OleCheck(CoRevertToSelf());
	}
	catch(Exception &e) {
		return Error(e.Message.c_str(), IID_IObjBlanket);
	}
	return S_OK;
};

