<?php
class ExamsController extends Controller {
	public function index() {
		$gradeValues = Set::extract(
   $this->Exam->find('all'),
   '/Grade/grade'
);
$average = array_sum($gradeValues) / count($gradeValues);
$categories = $this->Exam->Category->find('all');
$mappedCategories = Set::combine(
   $categories,
   '/Category/id',
   '/Category/name'
);
$gradeRows = $this->Exam->Grade->find('all', array(
   'recursive' => 2
));
$grades = Set::format(
   $gradeRows, 
   '%s otrzymał(a) ocenę %-.1f z przedmiotu %s (%s)',
   array(
      '/Student/name',
      '/Grade/grade',
      '/Exam/name',
      '/Exam/Category/name'
   )
);
$categories = Set::map($categories);
$this->set(compact('average', 'grades', 'categories'));

	}
}
?>