<?php
App::import(array('type'=>'File', 'name'=>'AppException', 'file'=>APP.'app_exception.php'));
App::import('Core', 'Controller');

class ExceptionHandler extends Object {
	public static function handleException($exception) {
        self::logException($exception);
        self::renderException($exception);
        self::_stop();
	}

	public static function renderException($exception) {
		$Dispatcher = new Dispatcher();
		$Controller = new Controller();

		$Controller->params = array(
			'controller' => 'exceptions',
			'action' => 'exception'
		);

		$Controller->viewPath = 'exceptions';
		if (file_exists(VIEWS.'layouts'.DS.'exception.ctp')) {
			$Controller->layout = 'exception';
		}
		$Controller->base = $Dispatcher->baseUrl();
		$Controller->webroot = $Dispatcher->webroot;
		$Controller->set(compact('exception'));

		$View = new View($Controller);
		if (!file_exists(VIEWS.'exceptions'.DS.'view.ctp')) {
			if (Configure::read('debug') > 0) {
				echo '<strong>Exception</strong>: ';
				echo $exception->getMessage();
				echo '<pre>';
				echo $exception->getStackTrace(false);
				echo '</pre>';
				return;
			}
			return $Controller->redirect(null, 500);
		}
		echo $View->render('view');
	}

	public static function logException($exception) {
		$trace = $exception->getStackTrace();
		$message = get_class($exception) . ' thrown in ' . $trace[0]['location'];
		$message .= ': ' . $exception->getMessage();
		if ($exception instanceof AppException) {
			$message .= ' | DEBUG: ' . var_export($exception->getInfo(), true);
		}
        self::log($message, LOG_ERROR);
	}
}
?>
