<?php
class ArticleTestCase extends CakeTestCase {
	public $fixtures = array('app.article', 'app.user', 'app.vote');

	public function startTest($method) {
		parent::startTest($method);
		$this->Article = ClassRegistry::init('Article');
	}

	public function endTest($method) {
		parent::endTest($method);
		ClassRegistry::flush();
	}

	public function testGet() {
		$article = $this->Article->get(1);
		$this->assertTrue(!empty($article) && !empty($article['Article']));
		$this->assertTrue(!empty($article[0]) && !empty($article[0]['vote']));
		$this->assertEqual(number_format($article[0]['vote'], 1), 4.3);

		$article = $this->Article->get(2);
		$this->assertTrue(!empty($article) && !empty($article['Article']));
		$this->assertTrue(!empty($article[0]) && !empty($article[0]['vote']));
		$this->assertEqual(number_format($article[0]['vote'], 1), 3.5);
	}

	/*public function testVote() {
		$result = $this->Article->vote(2, array('Vote' => array(
			'user_id' => 2
		)));
		$this->assertFalse($result);
		$this->assertTrue(!empty($this->Article->Vote->validationErrors['vote']));

		$result = $this->Article->vote(2, array('Vote' => array(
			'user_id' => 2,
			'vote' => 6
		)));
		$this->assertFalse($result);
		$this->assertEqual($this->Article->Vote->validationErrors['vote'], 'range');

		$result = $this->Article->vote(2, array('Vote' => array(
			'user_id' => 2,
			'vote' => 1
		)));
		$this->assertFalse($result);

		$result = $this->Article->vote(2, array('Vote' => array(
			'user_id' => 1,
			'vote' => 1
		)));
		$this->assertTrue($result);
		$article = $this->Article->get(2);
		$this->assertTrue(!empty($article[0]) && !empty($article[0]['vote']));
		$this->assertEqual(number_format($article[0]['vote'], 1), 2.7);

		$this->expectException();
		$this->Article->vote(2);
	}*/
}
?>
