<?php
App::import('Core', 'Security');
class UserShell extends Shell {
   public $uses = array('User');
   public function main() {
      $user = $this->in('Wprowadz nazwe uzytkownika (ENTER, aby przerwac):');
      if (empty($user)) {
         $this->_stop();
      }
      $defaultPassword = $this->_randomPassword();;
      $password = $this->in('Wprowadz haslo (ENTER, aby wygenerowac):', null, $defaultPassword);
      $this->out();
      $this->out('UZYTKOWNIK: '.$user);
      $this->out('HASLO: '.$password);
      $this->out();
      if (strtoupper($this->in('Wykonac?', array('Y', 'N'), 'N')) != 
'Y') {
         $this->_stop();
      }
      $user = array('User' => array(
         'username' => $user,
         'password' => Security::hash($password, null, true)
      ));
      $this->User->create();
      if ($this->User->save($user)) {
         $this->out('Utworzono uzytkownika.');
      } else {
         $this->error('Wystapil blad w trakcie tworzenia uzytkownika.');
      }
   }
   protected function _randomPassword($size=10) {
      $chars = '@!#$_';
      foreach(array('A'=>'Z', 'a'=>'z', '0'=>'9') as $start => $end) {
         for ($i=ord($start), $limiti=ord($end); $i <= $limiti; $i++) 
         {
            $chars .= chr($i);
         }
      }
      $totalChars = strlen($chars);
      $password = '';
      for($i=0; $i < $size; $i++) {
         $password .= $chars[rand(0, $totalChars-1)];
      }
      return $password;
   }
}
?>
