<?php
class SubscribersController extends AppController {
	public $components = array(
		'Email' => array(
			'delivery' => 'smtp',
			'smtpOptions' => array(
				'host' => 'smtp.email.com',
				'username' => 'smtpUser',
				'password' => 'smtpPassword'
			)
		)
	);
	public function add() {
		if (!empty($this->data)) {
			$this->Subscriber->create();
			if ($this->Subscriber->save($this->data)) {
				ClassRegistry::init('Robot.RobotTask')->schedule(
					array('action'=>'welcome'),
					array(
						'name' => $this->data['Subscriber']['email'],
						'email' => $this->data['Subscriber']['email']
					)
				);
				$this->Session->setFlash('You have been subscribed!');
				$this->redirect(array('action'=>'welcome'));
			} else {
				$this->Session->setFlash('Please correct the errors');
			}
		}
	}

	public function welcome() {
		if (isset($this->params['robot'])) {
			$subscriber = $this->params['robot'];

			$this->Email->sendAs = 'html';
			$this->Email->subject = 'Welcome to my site!';
			$this->Email->from = 'My Application <info@email.com>';
			$this->Email->to = $subscriber['name'] . ' <'.$subscriber['email'].'>';

			return ($this->Email->send('Hi, and <strong>welcome</strong> to my site!') !== false);
		}
	}
}
?>