<?php
class ProfilesController extends AppController {
	public function index() {
		$profiles = $this->Profile->find('all');
		$this->set(compact('profiles'));
	}

	public function view($userName) {
		$profile = $this->Profile->find('first', array(
			'conditions' => array('Profile.userName' => $userName)
		));
		if (empty($profile)) {
			$this->cakeError('error404');
		}
		$this->set(compact('profile'));
	}

	public function add() {
		if (!empty($this->data)) {
			$this->Profile->create($this->data);
			if ($this->Profile->save()) {
				$this->Session->setFlash('Profile created');
				$this->redirect(array(
					'action'=>'view',
					'userName' => $this->data['Profile']['username']
				));
			} else {
				$this->Session->setFlash('Please correct the errors below');
			}
		}
	}
}
?>