<?php
class PostsController extends AppController {
	public function add() {
		if (!empty($this->data)) {
			$this->Post->create();
			if ($this->Post->save($this->data)) {
				$this->Session->setFlash('Post created');
				$this->redirect('/');
			} else {
				$this->Session->setFlash('Please correct the errors');
			}
		}
	}

	public function index() {
		$this->paginate['limit'] = 10;
		$posts = $this->paginate();
		$this->set(compact('posts'));
	}

	public function view($slug) {
		$post = $this->Post->find('first', array(
			'conditions' => array('Post.slug' => $slug),
			'recursive' => -1
		));
		$this->set(compact('post'));
	}
}
?>