<?php
class Upload extends AppModel {
	protected $magicDb;

	public function beforeValidate($options = array()) {
		$result = parent::beforeValidate($options);

		$data = $this->data[$this->alias];
		if (!empty($data['file'])) {
			if (
				empty($data['file']) ||
				!is_array($data['file']) ||
				empty($data['file']['tmp_name']) ||
				!is_uploaded_file($data['file']['tmp_name'])
			) {
				$this->invalidate('file', 'No file uploaded');
				return false;
			}

			$magicDb = $this->getMagicDb();
			if (!isset($magicDb)) {
				$this->invalidate('file', 'Can\'t get instance of MagicDb');
				return false;
			}

			$path = TMP . $data['file']['name'];
			if (!move_uploaded_file($data['file']['tmp_name'], $path)) {
				$this->invalidate('file', 'Could not move uploaded file');
				return false;
			}

			$data['file'] = basename($path);
			unset($data['mime']);

			$analysis = $magicDb->analyze($path);
			if (!empty($analysis)) {
				$analysis = $analysis[0];
				if (preg_match('/^\[.+?;ext=[^;]+;mime=([^;]+);.*?\](.*)$/i', $analysis[3], $match)) {
					$data['mime'] = $match[1];
					if (empty($data['description'])) {
						$data['description'] = $match[2];
					}
				}
			}

			if (empty($data['mime'])) {
				$this->invalidate('Can\'t recognize file '.$data['file']);
				return false;
			}

			$this->data[$this->alias] = $data;
		} else {
			$this->invalidate('file', 'This field is required');
			return false;
		}

		return $result;
	}

	protected function getMagicDb() {
		if (!isset($this->magicDb)) {
			App::import('Core', 'MagicDb');
			$magicDb = new MagicDb();
			if (!$magicDb->read(APP . 'vendors' . DS . 'magic.db')) {
				return null;
			}
			$this->magicDb = $magicDb;
		}
		return $this->magicDb;
	}
}
?>