<?php
App::import('Core', 'Security');
class UserShell extends Shell {
   public $uses = array('User');
   public $tasks = array('Help');
public static $commands = array(
   'add',
   'import' => array(
      'help' => 'Pobierz rekordy z pliku CSV',
      'args' => array(
         'path' => array(
            'help' => 'Sciezka do pliku CSV',
            'mandatory' => true
         )
      ),
      'params' => array(
         'limit' => array(
            'type' => 'int',
            'help' => 'pobierz maksymalnie N rekordow'
         ),
         'size' => array(
            'value' => 10,
            'type' => 'int',
            'help' => 'dlugosc generowanego hasla'
         ),
         'verbose' => array(
            'value' => false,
            'type' => 'bool',
            'help' => 'wyswietlanie komunikatow w trakcie wykonywania procesu'
         )
      )
   )
);

   public function add() {
      $user = $this->in('Wprowadz nazwe uzytkownika (ENTER, aby przerwac):');
      if (empty($user)) {
         $this->_stop();
      }
      $defaultPassword = $this->_randomPassword();;
      $password = $this->in('Wprowadz haslo (ENTER, aby wygenerowac):', null, $defaultPassword);
      $this->out();
      $this->out('UZYTKOWNIK: '.$user);
      $this->out('HASLO: '.$password);
      $this->out();
      if (strtoupper($this->in('Wykonac?', array('Y', 'N'), 'N')) != 
'Y') {
         $this->_stop();
      }
      $user = array('User' => array(
         'username' => $user,
         'password' => Security::hash($password, null, true)
      ));
      $this->User->create();
      if ($this->User->save($user)) {
         $this->out('Utworzono uzytkownika.');
      } else {
         $this->error('Wystapil blad w trakcie tworzenia uzytkownika.');
      }
   }
   public function import() {
    $options = $this->Help->parameters;
	extract($this->Help->arguments);

   if (!is_file($path) || !is_readable($path)) {
      $this->error('Nie mozna odczytac pliku '.$path);
   }
   $users = array();
   foreach($this->_parseCSV($path) as $i => $row) {
      $users[$row[0]] = $this->_randomPassword($options['size']);
      if (!empty($options['limit']) && $i + 1 == $options['limit']) {
         break;
      }
   }
   if ($options['verbose']) {
      $this->out('Liczba kont do utworzenia: '.number_format(count($users)));
   }
   foreach($users as $userName => $password) {
      if ($options['verbose']) {
         $this->out('Tworzenie uzytkownika '.$userName.'... ', false);
      }
      $user = array('User' => array(
         'username' => $userName,
         'password' => Security::hash($password, null, true)
      ));
      $this->User->create();
      $saved = ($this->User->save($user) !== false);
      if (!$saved) {
         unset($users[$userName]);
      }
      if ($options['verbose']) {
         $this->out($saved ? 'SUKCES' : 'BLAD');
      }
   }
   $this->out('Utworzono nastepujace konta:');
   foreach($users as $userName => $password) {
      $this->out($userName.' : '.$password);
   }
}

 

   protected function _randomPassword($size=10) {
      $chars = '@!#$_';
      foreach(array('A'=>'Z', 'a'=>'z', '0'=>'9') as $start => $end) {
         for ($i=ord($start), $limiti=ord($end); $i <= $limiti; $i++) 
         {
            $chars .= chr($i);
         }
      }
      $totalChars = strlen($chars);
      $password = '';
      for($i=0; $i < $size; $i++) {
         $password .= $chars[rand(0, $totalChars-1)];
      }
      return $password;
   }
}
?>
