<?php
class Profile extends AppModel {
	public $validate = array(
		'username' => array(
			'notEmpty',
			'valid' => array(
				'rule' => 'validateUsername',
				'message' => 'This user name is reserved'
			)
		),
		'name' => 'notEmpty'
	);

	public function validateUsername($value, $params) {
		$reserved = Router::prefixes();

		$controllers = array_diff(
			Configure::listObjects('controller'),
			(array) 'App'
		);
		if (!empty($controllers)) {
			$reserved = array_merge($reserved, array_map(array('Inflector', 'underscore'), $controllers));
		}

		$routes = Router::getInstance()->routes;
		if (!empty($routes)) {
			foreach($routes as $route) {
				if (!empty($route->template) && preg_match('/^\/([^\/:]+)/', $route->template, $matches)) {
					$reserved[] = strtolower($matches[1]);
				}
			}
		}

		return !in_array(strtolower(array_shift($value)), $reserved);
	}

}
?>