<?php
class ArticlesController extends AppController {
	public function view($id) {
		$article = $this->Article->find('first', array(
			'conditions' => array('Article.id' => $id)
		));
		if (empty($article)) {
			$this->cakeError('error404');
		}
		$articles = $this->Article->find('all', array(
			'conditions' => array(
				'Category.id' => $article['Category']['id'],
				'Article.id !=' => $article['Article']['id']
			),
			'order' => 'RAND()'
		));
		$this->set(compact('article', 'articles'));
	}
}
?>