<?php
App::import('Controller', 'Articles');

class TestArticlesController extends ArticlesController {
    public $name = 'Articles';
    public $testRedirect = false;

	public function __construct() {
		parent::__construct();
		Configure::write('controllers.'.$this->name, $this);
	}

    public function beforeFilter() {
        if (isset($this->Session)) {
            App::import('Component', 'Session');
            Mock::generate('SessionComponent');
            $this->Session = new MockSessionComponent();
        }

        parent::beforeFilter();
    }

	public function redirect($url, $status = null, $exit = true) {
        $this->testRedirect = compact('url', 'status', 'exit');
        if ($exit) {
            $this->autoRender = false;
        }
    }
}

class ArticlesControllerTestCase extends CakeTestCase {
	public $fixtures = array('app.article', 'app.user', 'app.vote');

    public function testAction($url, $params = array()) {
        unset($this->Articles);
        $url = preg_replace('/^\/articles\//', '/test_articles/', $url);
        $result = parent::testAction($url, $params);
        $this->Articles = Configure::read('controllers.Articles');
        return $result;
    }

	public function testView() {
		$result = $this->testAction('/articles/view/0');
		$this->assertTrue(!empty($this->Articles->testRedirect));
		$this->assertEqual($this->Articles->testRedirect['url'], array('action' => 'index'));

		$result = $this->testAction('/articles/view/1', array('return'=>'vars'));
		$expected = array(
			'Article' => array(
				'id' => 1,
				'title' => 'Article 1',
				'body' => 'Body for Article 1'
			),
			0 => array(
				'vote' => 4.3333
			)
		);
		$this->assertTrue(!empty($result['article']));
		$this->assertEqual($result['article'], $expected);

		$result = $this->testAction('/articles/view/1', array('return'=>'view'));
		$this->assertTags($result, array(
			array('h1' => array()),
			'Article 1',
			'/h1',
			'Vote:',
			array('span' => array('id'=>'vote')),
			'4.3',
			'/span',
			array('p' => array()),
			'Body for Article 1',
			'/p'
		));
	}

	public function testVote() {
		$result = $this->testAction('/articles/vote/2', array(
			'data' =>  array(
				'Vote' => array(
					'user_id' => 1,
					'vote' => 1
				)
			)
		));

		$this->assertTrue(!empty($this->Articles->testRedirect));
		$this->assertEqual($this->Articles->testRedirect['url'], array('action' => 'index'));

        $this->Articles->Session->expectOnce('setFlash', array('Vote placed'));

		$article = $this->Articles->Article->get(2);
		$this->assertTrue(!empty($article) && !empty($article['Article']));
		$this->assertTrue(!empty($article[0]) && !empty($article[0]['vote']));
		$this->assertEqual(number_format($article[0]['vote'], 1), 2.7);
	}
}
?>
