<?php
App::import('Core', 'Security');
//App::import('Component', 'Auth');

class UserShell extends Shell {
	public $uses = array('User');
	public function main() {
		$user = $this->in('Enter the username (ENTER to abort):');
		if (empty($user)) {
			$this->_stop();
		}

		$defaultPassword = $this->_randomPassword();;
		$password = $this->in('Enter the password (ENTER to use generated):', null, $defaultPassword);

		$this->out();
		$this->out('USER: '.$user);
		$this->out('PASSWORD: '.$password);
		$this->out();

		if (strtoupper($this->in('Proceed?', array('Y', 'N'), 'N')) != 'Y') {
			$this->_stop();
		}

        //$this->Auth = new AuthComponent();

		$user = array('User' => array(
			'username' => $user,
			'password' => Security::hash($password, null, true)
            //'password' => $this->Auth->password($password)
		));

		$this->User->create();
		if ($this->User->save($user)) {
			$this->out('User created.');
		} else {
			$this->error('Error while creating user.');
		}
	}

	protected function _randomPassword($size=10) {
		$chars = '@!#$_';
		foreach(array('A'=>'Z', 'a'=>'z', '0'=>'9') as $start => $end) {
			for ($i=ord($start), $limiti=ord($end); $i <= $limiti; $i++) {
				$chars .= chr($i);
			}
		}

		$totalChars = strlen($chars);
		$password = '';
		for($i=0; $i < $size; $i++) {
			$password .= $chars[rand(0, $totalChars-1)];
		}
		return $password;
	}
}
?>
