<?php
class AppException extends Exception {
	public function getInfo() {
		return array(
			'message' => $this->getMessage(),
			'trace' => $this->getStackTrace(),
			'url' => Router::url(null, true),
			'method' => env('REQUEST_METHOD'),
			'referer' => env('HTTP_REFERER'),
			'POST' => $_POST,
			'GET' => $_GET,
			'SESSION' => $_SESSION
		);
	}

	public function getStackTrace($array = true, $count = 5) {
		if ($array) {
			$trace = $this->getTrace();
			if (!empty($count)) {
				$trace = array_slice($trace, 0, $count);
			}
			foreach($trace as $i => $row) {
				$location = '';
				if (!empty($row['class'])) {
					$location .= $row['class'] . $row['type'] . $row['function'] . '()';
				}
				$file = !empty($row['file']) ? str_replace(ROOT.DS, '', $row['file']) : '';
				if (!empty($file)) {
					if (!empty($location)) {
						$location .= ' (' . $file . '@' . $row['line'] . ')';
					} else {
						$location .= $file . '@' . $row['line'];
					}
				}

				$trace[$i]['location'] = $location;
				unset($trace[$i]['args']);
			}
			return $trace;
		}
		return $this->getTraceAsString();
	}
}
?>