<?php
class PostsController extends AppController {
	public $components = array('RequestHandler');
	public $helpers = array('Cache');

	public function beforeFilter() {
		parent::beforeFilter();
		if ($this->RequestHandler->isRss()) {
			$this->cacheAction = array($this->action => '1 hour');
		}
	}

	public function index() {
		$options = array();
		if ($this->RequestHandler->isRss()) {
			$options = array_merge($options, array(
				'order' => array('Post.created' => 'desc'),
				'limit' => 5
			));
		}
		$posts = $this->Post->find('all', $options);
		$this->set(compact('posts'));
	}

	public function view($id) {
		$post = $this->Post->find('first', array(
			'conditions' => array('Post.id' => $id)
		));
		if (empty($post)) {
			$this->cakeError('error404');
		}
		$this->set(compact('post'));
	}
}
?>