<?php
App::import('Core', 'HttpSocket');

class TwitterAccountBehavior extends ModelBehavior {
	protected static $httpSocket;

	public function setup($model, $config = array()) {
		parent::setup($model, $config);
		$this->settings[$model->alias] = array_merge(array(
			'field' => 'twitter'
		), $config);
	}

	public function validateTwitter($model, $data) {
		$field = $this->settings[$model->alias]['field'];
		if (!empty($data[$field])) {
			$value = $data[$field];
			$result = $this->timeline($value, 1, true);
			if ($result['status'] == 404) {
				$result = false;
			}
		}
		return $result;
	}

	public function beforeFind($model, $query) {
		$this->settings[$model->alias]['tweets'] = !isset($query['tweets']) ? true : $query['tweets'];
		return parent::beforeFind($model, $query);
	}

	public function afterFind($model, $results, $primary) {
		$rows = parent::afterFind($model, $results, $primary);
		if (!is_null($rows)) {
			$results = $rows;
		}
		if (!empty($this->settings[$model->alias]['tweets'])) {
			$field = $this->settings[$model->alias]['field'];
			$count = is_int($this->settings[$model->alias]['tweets']) ?
				$this->settings[$model->alias]['tweets'] :
				10;
			foreach($results as $i => $result) {
				$twitter = $result[$model->alias][$field];
				$tweets = array();
				if (!empty($result[$model->alias][$field])) {
					$result = $this->timeline($twitter, $count);
					if (!empty($result) && is_array($result)) {
						foreach($result as $tweet) {
							$tweets[] = array(
								'created' => date('Y-m-d H:i:s', strtotime($tweet->created_at)),
								'source' => $tweet->source,
								'user' => $tweet->user->screen_name,
								'text' => $tweet->text
							);
						}
					}
				}
				$results[$i]['Tweet'] = $tweets;
			}
		}
		return $results;
	}

	public function beforeSave($model) {
		$field = $this->settings[$model->alias]['field'];
		$twitter = null;
		if (!array_key_exists($field, $model->data[$model->alias]) && $model->exists()) {
			$twitter = $model->field($field, array(
				$model->primaryKey => $model->id
			));
		} elseif (array_key_exists($field, $model->data[$model->alias])) {
			$twitter = $model->data[$model->alias][$field];
		}

		$data = array(
            'url' => !empty($twitter) ? 'http://twitter.com/' . $twitter : null,
            'last_tweet' => null
        );
		if (!empty($twitter)) {
			$tweets = $this->timeline($twitter, 1);
			if (!empty($tweets) && is_array($tweets)) {
				$data['last_tweet'] = $tweets[0]->text;
			}
		}

        $model->data[$model->alias] = array_merge(
            $model->data[$model->alias],
            $data
        );
        $this->_addToWhitelist($model, array_keys($data));

		return parent::beforeSave($model);
	}

	protected function timeline($twitter, $count = 10, $returnStatus = false) {
		if (!isset(self::$httpSocket)) {
			self::$httpSocket = new HttpSocket();
		}

		$content = self::$httpSocket->get('http://twitter.com/status/user_timeline/' . $twitter . '.json?count=' . $count);
		$status = self::$httpSocket->response['status']['code'];
		if (!empty($content)) {
			$content = json_decode($content);
		}

		if ($returnStatus) {
			return compact('status', 'content');
		}
		return $content;
	}
}
?>
