<?php
class UsersController extends AppController {
	public function beforeFilter() {
		parent::beforeFilter();
		$this->Auth->allow('add');
	}
	public function add() {
		if (!empty($this->data)) {
			$this->User->create();
			if ($this->User->save($this->data)) {
				$this->Session->setFlash('User created!');
				$this->redirect(array('action'=>'login'));
			} else {
				$this->Session->setFlash('Please correct the errors');
			}
		}
	}
	public function login() {
        if (!empty($this->data)) {
            $userId = $this->Auth->user('id');
            if (!empty($userId)) {
                if (!empty($this->data['User']['remember'])) {
                    $user = $this->User->find('first', array(
                        'conditions' => array('id' => $userId),
                        'recursive' => -1,
                        'fields' => array('username', 'password')
                    ));
                    $this->Cookie->write('User', array_intersect_key(
                        $user[$this->Auth->userModel],
                        array('username'=>null, 'password'=>null)
                    ));
                } elseif ($this->Cookie->read('User') != null) {
                    $this->Cookie->delete('User');
                }
                $this->redirect($this->Auth->redirect());
            }
        }
	}
	public function logout() {
        if ($this->Cookie->read('User') != null) {
            $this->Cookie->delete('User');
        }
		$this->redirect($this->Auth->logout());
	}
}
?>
