<?php
class AppController extends Controller {
	public $components = array(
		'Auth' => array(
			'authorize' => 'controller',
			'loginRedirect' => array(
				'admin' => false,
				'controller' => 'users',
				'action' => 'dashboard'
			)
		),
		'Session'
	);
	public function isAuthorized() {
		$role = $this->Auth->user('role');
		$neededRole = null;
		$prefix = !empty($this->params['prefix']) ?
			$this->params['prefix'] :
			null;
		if (
			!empty($prefix) &&
			in_array($prefix, Configure::read('Routing.prefixes'))
		) {
			$neededRole = $prefix;
		}
		return (
			empty($neededRole) ||
			strcasecmp($role, 'admin') == 0 ||
			strcasecmp($role, $neededRole) == 0
		);
	}
}
?>
