#include <iostream.h>
#include <fstream.h>
#include "personal.h"
#include "student.h"
#include "database.h"

template<class T>
Database<T>::Database() {
    cout << "Nazwa pliku: ";
    cin >> fName;
}

template<class T>
void Database<T>::add(T& d) {
    database.open(fName,ios::in|ios::out|ios::binary);
    database.seekp(0,ios::end);
    d.writeToFile(database);
    database.close();
}

template<class T>
void Database<T>::modify(const T& d) {
    T tmp;
    database.open(fName,ios::in|ios::out|ios::binary);
    while (!database.eof()) {
        tmp.readFromFile(database);
        if (tmp == d) {  // przeciony ==
             cin >> tmp; // przeciony >>
             database.seekp(-d.size(),ios::cur);
             tmp.writeToFile(database);
             database.close();
             return;
        }
    }
    database.close();
    cout << "Modyfikowanego rekordu nie ma w bazie danych\n";
}

template<class T>
bool Database<T>::find(const T& d) {
    T tmp;
    database.open(fName,ios::in|ios::binary);
    while (!database.eof()) {
        tmp.readFromFile(database);
        if (tmp == d) { // przeciony ==
            database.close();
            return true;
        }
    }
    database.close();
    return false;
}

template<class T>
ostream& Database<T>::print(ostream& out) {
    T tmp;
    database.open(fName,ios::in|ios::binary);
    while (1) { 
        tmp.readFromFile(database);
        if (database.eof())
            break;
        out << tmp << endl; // przeciony <<
    }
    database.close();
    return out;
}

template<class T>
void Database<T>::run() {
    char option[5];
    T rec;
    cout << "1. Dodaj 2. Znajd 3. Modyfikuj rekord; 4. Koniec\n";
    cout << "Podaj opcj: ";
    cin.getline(option,4); // pobierz opcj wraz z '\n';
    while (cin.getline(option,4)) {
        if (*option == '1') {
             cin >> rec;   // przeciony >>
             add(rec);
        }
        else if (*option == '2') {
             rec.readKey();
             cout << "Rekord ";
             if (find(rec) == false)
                 cout << "nie ";
             cout << "istnieje w bazie danych\n";
        }
        else if (*option == '3') {
             rec.readKey();
             modify(rec);
        }
        else if (*option != '4')
             cout << "Nieprawidowa opcja\n";
        else return;
        cout << *this;   // przeciony <<
        cout << "Podaj opcj: ";
    }
}

void main() {
    Database<Personal> db;
//    Database<Student> db;
    db.run();
};
